import copy
import hashlib

import MySQLdb
import pandas as pd
import googlemaps

# 18|10-40|1552.23,1223.87
import time
import sys
from datetime import datetime

'''
Step 1: For each row calculate which of the tech_ids is closest
Step 2: Prepare a global array of techs, and remove all duplicates
Step 3: Round varies for X, X = 1 to Y. Read each order, and assign closest tech, unless, tech already  has X job assigned, if so, assign to next closest tech. Each time closest tech is assigned, update tech's current location to the last assigned location. Also ignore tech if tech reaches max.
step 4: once all techs are assigned X, X = X+1. X continues to Y until all are assigned
00:55
round completes when all techs who have not reached max capacity are assigned 1 order in current round
whether at any node, distance from  current techs node and next node is > distance between different techs any node and my next node.
'''


class Router:
    gmaps = None
    db = None
    # empty list
    nurse_data = {}
    location_points = {}
    order_data = {}
    dos = ""
    server = 1

    def __init__(self):
        # Perform request to use the Google Maps API web service
        API_key = 'AIzaSyBGaPMGd9q4VK97U0pI_VNREGpUQ9iOXuc'  # enter Google Maps API key
        self.gmaps = googlemaps.Client(key=API_key)

    def connect(self):
        if self.server == 1: # demo server
            username = "phlebiod_logger"
            password = "C^x3N@%S#;Kw"
            host = "phlebiodemo.com"
            database = "phlebiod_laramain"

        if self.server == 2: #poc
            username = "mhealthphlebio_pocuser"
            password = "Phlebio@db@poc"
            host = "localhost"
            database = "mhealthphlebio_POC_Phlebio"

        if self.server == 3: #tst
            username = "mhealthphlebio_tstuser"
            password = "Phlebio@TST_2020%%%"
            host = "localhost"
            database = "mhealthphlebio_TST_Phlebio"

        if self.server == 4: #prod
            username = "mhealthphlebio_secure007user"
            password = "Phlebio@PROD_2020&&&"
            host = "localhost"
            database = "mhealthphlebio_PROD"


        self.db = MySQLdb.connect(host, username, password, database)

    def read_data(self, date_of_service):

        self.connect()

        tech_metadata = []
        self.dos = date_of_service
        # prepare a cursor object using cursor() method
        cursor = self.db.cursor()

        # first fetch the first row to generate shortest path
        fetch_query = """ SELECT * FROM tbl_detail_lambda_input WHERE delete_status = 0 AND DOS=%s LIMIT 0,1"""
        cursor.execute(fetch_query, [date_of_service])
        # Fetch the row
        first_result = cursor.fetchone()
        if first_result is not None:
            first_latitude = first_result[4]
            first_longitude = first_result[5]

            fetch_query = """ SELECT *,(
            6371 *
            acos(
                cos( radians( %s ) ) *
                    cos( radians( `latitude` ) ) *
                cos(
                    radians( `longitude` ) - radians( %s )
                ) +
                sin(radians(%s)) *
                sin(radians(`latitude`))
            )
        ) `distance` FROM tbl_detail_lambda_input WHERE delete_status = 0 AND DOS=%s and latitude!="" and longitude!="" ORDER BY `distance` DESC"""
            try:
                # Execute the SQL command
                cursor.execute(fetch_query, [first_latitude, first_longitude, first_latitude, date_of_service])
                # Fetch all the rows in a list of lists.
                results = cursor.fetchall()
                print("totals results in db %s", (results.__len__()))
                for row in results:
                    client_id = row[3]
                    latitude = row[4]
                    longitude = row[5]
                    order_ids = row[6]
                    tech_ids = row[8]
                    latlong_hash = hashlib.sha256((latitude + "," + longitude).encode('utf-8')).hexdigest()

                    tech_data = tech_ids.split("#")
                    local_tech_ids = []
                    if tech_data.__len__() > 0:
                        for each_tech in tech_data:
                            tech_metadata = each_tech.split("|")
                            if tech_metadata.__len__() > 0:
                                tech_id = tech_metadata[0]
                                local_tech_ids.append(tech_id)
                                if not tech_id in self.nurse_data:
                                    # print(tech_metadata)
                                    tech_minmax = tech_metadata[1].split("-")
                                    tech_latlong = tech_metadata[2].split(",")
                                    max = int(tech_minmax[1])
                                    this_tech = {
                                        "id": tech_id,
                                        "min": int(tech_minmax[0]),
                                        "max": max,
                                        "home_latitude": tech_latlong[0],
                                        "home_longitude": tech_latlong[1],
                                        "latitude": tech_latlong[0],
                                        "longitude": tech_latlong[1],
                                        "allocated": 0,
                                        "stop": 0,
                                        "stops": []
                                    }
                                    self.nurse_data[tech_id] = this_tech
                                    # Now print fetched result
                                    # print("client_id=%s,latitude=%s,longitude=%s,order_ids=%s,tech_ids=%s" %
                                    #       (client_id, latitude, longitude, order_ids, tech_ids))
                    if not latlong_hash in self.location_points:
                        # this location isnt there
                        self.location_points[latlong_hash] = {
                            "latitude": latitude,
                            "longitude": longitude,
                            "order_data": []
                        }

                    self.location_points[latlong_hash]['order_data'].append({
                        "client_id": client_id,
                        "latitude": latitude,
                        "longitude": longitude,
                        "order_ids": order_ids,
                        "tech_ids": local_tech_ids,
                        "allocated_tech_id": 0,
                        "tech_stop_order": 0

                    })

            except (MySQLdb.Error, MySQLdb.Warning) as e:
                print(e)
                print("Error: unable to fetch data")
        else:
            print("Error: No records found for this date")

    def print_output(self):
        pd.set_option('display.max_rows', None)
        pd.set_option('display.max_columns', None)
        pd.set_option('display.width', None)
        pd.set_option('display.max_colwidth', -1)

        # print("*******************************************************************************\n")
        # print("FINAL NURSE ALLOCATION\n")
        # print("*******************************************************************************\n")
        #
        # nurse_df = pd.DataFrame(self.nurse_data)
        # print(nurse_df)
        #
        # print("*******************************************************************************\n")
        # print("FINAL ORDER ALLOCATION\n")
        # print("*******************************************************************************\n")
        print_orders = copy.deepcopy(self.location_points)

        self.connect()

        cursor = self.db.cursor()

        tuples = []

        sql_insert_query = """ INSERT INTO tbl_lambda_techroute_output_test
                       (DOS, tech_id, stop, stop_coord, client_id, order_id) VALUES (%s,%s,%s,%s,%s,%s)"""

        for orders in print_orders:
            # print ("%s",(orders))
            # print("\n")
            for order in print_orders[orders]['order_data']:
                order['tech_ids'] = ",".join(order['tech_ids'])
                location_df = pd.DataFrame(order, [1])
                print(location_df)
                stop = 0
                if order['allocated_tech_id'] != 0:
                    # self.nurse_data[order['allocated_tech_id']]["stop"] += 1
                    # stop = self.nurse_data[order['allocated_tech_id']]["stop"]
                    for stops in self.nurse_data[order['allocated_tech_id']]['stops']:
                        if stops[0] == order['latitude'] and stops[1] == order['longitude'] and stops[3] == order[
                            'order_ids']:
                            stop = stops[2] + 1
                            print("appending to table "+  str(order['allocated_tech_id'])+":"  + str(stop)+ ":"+
                                  order['latitude'] + "," + order['longitude']+":"+ str(order['client_id']))
                            tuples.append([self.dos, order['allocated_tech_id'], stop,
                                           order['latitude'] + "," + order['longitude'], order['client_id'],
                                           order['order_ids']])
                            break
                else:
                    tuples.append([self.dos, 0, 0, order['latitude'] + "," + order['longitude'], order['client_id'],
                                   order['order_ids']])

        for db_tuple in tuples:
            cursor.execute(sql_insert_query, db_tuple)
        self.db.commit()

    def process_route(self):
        # allocate to everyone
        # allocate at least min
        # don't allocate more than max
        for orders in self.location_points:
            # print ("%s",(orders))
            # print("\n")
            for order in self.location_points[orders]['order_data']:

                result = self.calculate_closest_tech(order['latitude'], order['longitude'], order['tech_ids'])
                if int(result[0]) > 0:
                    order['allocated_tech_id'] = result[0]
                    multi_orders = order['order_ids'].split(",")

                    self.nurse_data[result[0]]["allocated"] += multi_orders.__len__()
                    self.nurse_data[result[0]]["latitude"] = order['latitude']
                    self.nurse_data[result[0]]["longitude"] = order['longitude']
                    self.nurse_data[result[0]]["stops"].append(
                        [order['latitude'], order['longitude'], 0, order['order_ids']])

                    print("Client_id=%s,order_ids=%s has available techs %s - " %
                          (order['client_id'], order['order_ids'], order["tech_ids"]))

                    print("It is allocated to tech_ids=%s at distance=%s who now has %s orders \n" %
                          (result[0], result[1], self.nurse_data[result[0]]["allocated"]))
                    print("###############################################\n")

                    # nurse_df = pd.DataFrame(self.nurse_data)
                    # print(nurse_df)

    def route_data(self):
        pass

    def optimize_tech_routes(self):
        # https://maps.googleapis.com/maps/api/directions/json?origin=Adelaide,SA&destination=Adelaide,SA&waypoints=optimize:true|Barossa+Valley,SA|Clare,SA|Connawarra,SA|McLaren+Vale,SA
        origin = ""
        destination = ""

        for nurse in self.nurse_data:
            route_waypts = ""
            if self.nurse_data[nurse]['stops'].__len__() > 0:
                index = 0
                for stop in self.nurse_data[nurse]['stops']:
                    print(index)
                    print(stop)
                    print("\n*********")
                    destination = (self.nurse_data[nurse]['home_latitude'], self.nurse_data[nurse]['home_longitude'])
                    if index == 0:
                        origin = (stop[0], stop[1])
                        stop[2] = 0
                    # elif index == self.nurse_data[nurse]['stops'].__len__() - 1:
                    #    destination = (stop[0], stop[1])
                    #    stop[2] = self.nurse_data[nurse]['stops'].__len__() - 1
                    else:
                        route_waypts = route_waypts + stop[0] + "," + stop[1] + "|"
                    index += 1
                # print("=============== ROUTING ====================\n")
                # print(origin)
                # print(destination)
                # print(route_waypts)
                optimized_route = self.gmaps.directions(origin, destination, mode='driving', waypoints=route_waypts,
                                                        optimize_waypoints=True)
                preferred_waypoints = optimized_route[0]['waypoint_order']
                print("************** CURRENT STOPS ******************\n")
                print(self.nurse_data[nurse]['stops'])
                print("*************** PREFERRED WAYPOINTS ***************\n")
                print(preferred_waypoints)
                # print("*************** JSON RESPONSE ***************\n")
                # print(optimized_route)
                print("*************** URL ***************\n")
                print("https://maps.googleapis.com/maps/api/directions/json?origin=" + ','.join(
                    origin) + "&destination=" + ','.join(destination) + "&waypoints=optimize:true|" + route_waypts)
                index = 1
                # [6,8,0,7,5,4,3,2,1]
                for waypoint in preferred_waypoints:
                    print("putting " + str(waypoint + 1) + " to " + str(index))
                    self.nurse_data[nurse]['stops'][(waypoint + 1)][2] = index
                    index += 1
                time.sleep(1)
                print("************** CURRENT STOPS FILLED ******************\n")
                print(self.nurse_data[nurse]['stops'])


                # print(optimized_route)
                # break
                # latlong_hash = hashlib.sha256((latitude + "," + longitude).encode('utf-8')).hexdigest()

    def test_route(self):
        optimized_route = self.gmaps.directions(('45.3062538', '-93.6303427'), ('45.1803518', '-93.1098054'),
                                                mode='driving',
                                                waypoints="45.220055,-93.351789|45.1853886,-93.1083249|45.1803518,-93.1098054|",
                                                optimize_waypoints=True)
        print(optimized_route[0]['waypoint_order'])

    def calculate_closest_tech(self, latitude, longitude, tech_ids):
        nurse_id = 0
        distance = -1
        for tech_id in tech_ids:

            nurse = self.nurse_data[tech_id]

            if int(nurse['allocated']) < int(nurse['max']) and nurse["stops"].__len__() < 25:
                this_distance = self.calculate_distance(latitude, longitude, nurse['latitude'], nurse['longitude'])
                # print("distance for nurse:%s is %s \n" % (nurse['id'], this_distance))

                if int(this_distance) < distance or distance == -1:
                    nurse_id = nurse['id']
                    distance = this_distance

        return [nurse_id, distance]

    def calculate_distance(self, latitude_src, longitude_src, latitude_dest, longitude_dest):
        origin = (latitude_src, longitude_src)
        destination = (latitude_dest, longitude_dest)
        result = self.gmaps.distance_matrix(origin, destination, mode='driving')["rows"][0]["elements"][0]["distance"][
            "value"]
        return result

    def test_route(self):

        optimized_route = self.gmaps.directions((45.0991411, -93.2000812), (45.0236935, -93.1055542), mode='driving',
                                                waypoints="44.935796,-93.639281|44.9358792,-93.6390276|44.9358792,-93.6390276|44.9351563,-93.6391795|44.9352406,-93.6380592|45.0370951,-93.512996|45.0660271,-93.2233286|45.0660271,-93.2233286|44.9985805,-93.0587555",
                                                optimize_waypoints=True)
        print(optimized_route)

    def optimize_waypoints(self, tech_id, date_of_service):

        try:
            self.connect()

            tech_metadata = []
            self.dos = date_of_service
            # prepare a cursor object using cursor() method
            cursor = self.db.cursor()

            print("*************** Running Optimization again ***************\n")


            # first fetch the first row to generate shortest path
            # sql_insert_query = """ INSERT INTO tbl_lambda_techroute_output_test
            #               (DOS, tech_id, stop, stop_coord, client_id, order_id) VALUES (%s,%s,%s,%s,%s,%s)"""
            fetch_query = """ SELECT * FROM tbl_lambda_techroute_output_test WHERE status = 1 AND tech_id=%s AND DOS=%s"""
            cursor.execute(fetch_query, [tech_id, date_of_service])
            results = cursor.fetchall()
            origin=""
            destination=""
            route_waypts =""
            coords = []
            if results.__len__() > 0:
                print("totals results in db %s", (results.__len__()))
                index = 0
                for row in results:
                    id = row[0]
                    stop=row[4]
                    stop_coord=row[5]
                    print("id "+str(id)+" at position "+str(index)+" is  at stop "+str(stop)+" with coords "+ stop_coord)

                    if index == 0:
                        origin = stop_coord
                    else:
                        if index == (results.__len__()-1):
                            destination = stop_coord
                        else:
                            coords.append(stop_coord)
                            route_waypts = route_waypts + stop_coord + "|"
                    index += 1


                optimized_route = self.gmaps.directions(origin, destination, mode='driving', waypoints=route_waypts,
                                                        optimize_waypoints=True)
                preferred_waypoints = optimized_route[0]['waypoint_order']
                print("*************** PREFERRED WAYPOINTS ***************\n")
                print(preferred_waypoints)
                print(coords)

                tuples = []

                sql_update_query = """ update tbl_lambda_techroute_output_test SET
                       stop = %s, status = %s WHERE id = %s"""

                # [6,8,0,7,5,4,3,2,1]
                index = 0
                #results = list(results)
                results = list(map(list,results))

                for waypoint in preferred_waypoints:
                    stop = index + 2
                    actual_index = waypoint+1
                    print("putting " + str(actual_index) + " to " + str(stop))
                    #results[index][4]= stop
                    tuples.append([stop, 2,results[actual_index][0]])
                    print(results[actual_index][4])
                    results[actual_index][4] = stop
                    index += 1

                for db_tuple in tuples:
                    cursor.execute(sql_update_query, db_tuple)
                self.db.commit()
                print("*************** AFTER OPTIMIZATION  ***************\n")
                index=0
                for row in results:
                    id = row[0]
                    stop=row[4]
                    stop_coord=row[5]
                    print("id "+str(id)+" at position "+str(index)+" is  at stop "+str(stop)+" with coords "+ stop_coord)
                    index +=1


            else:
                print("Error: No records found for this date")

        except (MySQLdb.Error, MySQLdb.Warning) as e:
            print(e)
            print("Error: unable to fetch data")



n = len(sys.argv)
# print("Total arguments passed:", n)
run_date = datetime.today().strftime('%Y-%m-%d')
type = 0
chosen_server = 1
if n == 1:
    print("\nNo date specified, assuming today's date: " + run_date)
else:
    for i in range(1, n):
        # print("\n"+sys.argv[i], end = " ")

        current_argument = sys.argv[i]
        if current_argument == "phlebio":
           chosen_server = 1
        if current_argument == "poc":
           chosen_server = 2
        if current_argument == "tst":
           chosen_server = 3
        if current_argument == "prod":
           chosen_server = 4


        if i==1:
            first_param = sys.argv[i]
            if first_param == "optimize":
                type=1
            else:
                run_date=first_param
                print("\nRunning route generation for: " + run_date)
        if i==2:
            if type==1:
                run_date = sys.argv[i]
        if i==3:
            if type==1:
                tech_id = sys.argv[i]

date_format = '%Y-%m-%d'
print("chosen server - "+str(chosen_server))

try:
    date_obj = datetime.strptime(run_date, date_format)
    router = Router()
    router.server = chosen_server

    if type == 0:
        print ("plotting path")
        router.read_data(run_date)
        router.process_route()
        router.optimize_tech_routes()
        router.print_output()
    if type== 1:
        print ("optimizing route")
        router.optimize_waypoints(tech_id,run_date)
    # router.test_route()

except ValueError:
    print("Incorrect data format, should be YYYY-MM-DD")
